@extends('layouts.master')

@section('page-title', 'Ticket')

@section('content')
    <div class="container-fluid">
        <div class="card direct-chat direct-chat-primary">
            <div class="card-header ui-sortable-handle " style="cursor: move;">
                <h3 class="card-title">{{ $ticket->title }}</h3>
                <div class="card-tools">
                    <span title="3 New Messages" class="badge badge-primary">3</span>
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" title="Contacts" data-widget="chat-pane-toggle">
                        <i class="fas fa-comments"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="card-body">

                <div class="direct-chat-messages" style="height:400px">
                    @foreach ($ticket->ticketDetails as $detail)
                        <div class="direct-chat-msg {{ $detail->user_id == Auth::user()->id ? 'right' : 'left' }}">
                            <div class="direct-chat-infos clearfix">
                                <span
                                    class="direct-chat-name float-{{ $detail->user_id == Auth::user()->id ? 'right' : 'left' }}">{{ $detail->UserCreate->fullname }}</span>
                                <span
                                    class="direct-chat-timestamp float-{{ $detail->user_id == Auth::user()->id ? 'left' : 'right' }}">{{ $detail->UserCreate->created_at }}</span>
                            </div>
                            <img class="direct-chat-img"
                                src="https://images.freeimages.com/fic/images/icons/573/must_have/256/user.png?fmt=webp&w=350"
                                alt="message user image">
                            <div class="direct-chat-text">
                                {!! $detail->contentData !!}
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="card-footer">
                <textarea id="myTextarea" cols="3" required></textarea>
                <div class="input-group">
                    <span class="input-group-append">
                        @can('reply ticket')
                            <button type="button" class="btn btn-primary" id="replyButton"> {{ __('ticket.Reply') }}</button>
                        @endcan
                        @can('reject ticket')
                            <button type="button" class="btn btn-danger" id="stopButton">Reject</button>
                        @endcan
                        @can('solved ticket')
                            <button type="button" class="btn btn-danger" id="solvedButton">Solved Ticket</button>
                        @endcan
                        @can('finish ticket')
                            <button type="button" class="btn btn-success" id="finishButton">Finish</button>
                        @endcan

                    </span>
                </div>
            </div>
        </div>
    </div>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            tinymce.init({
                selector: 'textarea#myTextarea',
                plugins: 'fullscreen autolink lists link image charmap preview anchor',
                toolbar: 'fullscreen | undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                images_upload_url: '{{ route('tinymce.upload') }}',
                images_upload_base_path: '', // Thư mục gốc cho ảnh đã tải lên
                images_upload_credentials: false, //
                images_upload_headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('#replyButton').click(function() {
                var myContent = tinymce.get("myTextarea").getContent();
                console.log(myContent);
                $.ajax({
                    type: "PUT",
                    url: "{{ route('ticket.update', ['ticket' => $ticket->id]) }}",
                    data: {
                        content: myContent
                    },
                    success: function(response) {
                        tinymce.get("myTextarea").setContent('');
                        location.reload();
                    },
                    error: function(xhr, status, error) {
                        console.log(status);
                        var response = JSON.parse(xhr.responseText);
                        response.errors.content.forEach(element => {
                            toastr[status](element);
                        });

                    }

                });
            })
        });
    </script>
@endsection
