<!-- resources/views/auth/change-password.blade.php -->

@extends('layouts.master')

@section('Page-title', 'Change Password')

@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="py-3 mb-4 pt-5"><span class="text-muted fw-light"></span>Change Password</h4>

        <div class="row">
            <div class="col-12">
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('errors'))
                    @foreach ($errors->all() as $error)
                        <div class="alert alert-danger">{{ $error }}</div>
                    @endforeach
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif

                <form action="{{ route('change.password.post') }}" method="post">
                    @csrf
                    <div class="form-group position-relative">
                        <label for="password">New Password</label>
                        <small class="text-danger"
                               title="min 12 characters, at least one uppercase letter, one lowercase letter, one number and one special character">
                            (*) </small>
                        <input type="password" name="password" class="form-control" id="password"
                               placeholder="New Password" required>
                        <i class="fa fa-eye position-absolute" id="togglePassword"
                           style="top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer;"></i>
                    </div>

                    <div class="form-group position-relative">
                        <label for="password_confirmation">{{ translate('user.Confirm Password') }}</label>
                        <small class="text-danger"
                               title="min 12 characters, at least one uppercase letter, one lowercase letter, one number and one special character">
                            (*) </small>
                        <input type="password" name="password_confirmation" class="form-control"
                               id="password_confirmation" placeholder="Confirm Password" required>
                        <i class="fa fa-eye position-absolute" id="togglePasswordConfirm"
                           style="top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer;"></i>
                    </div>

                    <button type="submit" class="btn btn-primary mt-2">{{translate('user.Change')}}</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const togglePassword = document.querySelector("#togglePassword");
            const password = document.querySelector("#password");
            const togglePasswordConfirm = document.querySelector("#togglePasswordConfirm");
            const passwordConfirm = document.querySelector("#password_confirmation");

            // Toggle visibility for New Password
            togglePassword.addEventListener("click", function () {
                const type = password.getAttribute("type") === "password" ? "text" : "password";
                password.setAttribute("type", type);
                this.classList.toggle("fa-eye-slash");
            });

            // Toggle visibility for Confirm Password
            togglePasswordConfirm.addEventListener("click", function () {
                const type = passwordConfirm.getAttribute("type") === "password" ? "text" : "password";
                passwordConfirm.setAttribute("type", type);
                this.classList.toggle("fa-eye-slash");
            });
        });

    </script>
@endsection
