<x-guest-layout>
    <x-auth-card>
        <x-slot name="logo">
            <a href="/">
                <x-application-logo class="w-20 h-20 fill-current text-gray-500"/>
            </a>
        </x-slot>

        <div class="mb-4 text-sm text-gray-600">
            {{ __('auth.mail sent text')}}
        </div>

        @if (session('status') == 'verification-link-sent')
            <div class="mb-4 font-bold text-lg text-green-600">
                {{ __('A new verification link has been sent to the email address you provided during registration.') }}
            </div>
        @endif


        <form method="POST" action="{{ route('send-active') }}">

            <!-- Name -->
            <div>
                <x-label for="username" value="{{ __('auth.Username') }}" />
                <x-input id="username" class="block mt-1 w-full" type="text" name="username" :value="old('username')"
                         required
                         autofocus/>
            </div>
            <div>
                <x-label for="email" :value="('Email')"/>
                <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')"
                         required
                         autofocus/>
            </div>
            <div class="mt-4 flex items-center justify-between">
                <div class="g-recaptcha" data-sitekey="6LekIJcpAAAAAGnApe7Ss2z4jY6fLiCqzqFCJy9U"></div>
            </div>
            <div class="mt-4 flex items-center justify-between">
                @csrf

                <div>

                    <x-button>
                        {{ __('auth.Resend verification email') }}
                    </x-button>

                    <a class="underline text-sm text-gray-600 hover:text-gray-900" href="./login">
                        {{ __('auth.Back to login')}}
                    </a>
                </div>
            </div>
        </form>
    </x-auth-card>
</x-guest-layout>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
    $(document).ready(function () {
        $('form').submit(function (event) {
            var recaptcha = grecaptcha.getResponse();
            if (recaptcha.length === 0) {
                event.preventDefault();
                alert('Please complete the reCAPTCHA.');
            }
        });
    });
</script>
