<?php


use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\FactoriesController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PermissionsController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\SubTaksController;
use App\Http\Controllers\TaskProcessingController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\Testcontroller;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\MessengersController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\ReportsConroller;
use App\Models\Permission;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


require __DIR__ . '/auth.php';


Route::get('/change-language/{locale}', [\App\Http\Controllers\LanguageController::class, 'changeLanguage'])->name('change.language');


// TEST HERE

Route::get('/testJob', [Testcontroller::class, 'testJob']);
//  Route::get('/test1', [HomeController::class, 'test1']);
// Route::get('/test2', [HomeController::class, 'test2']);


Route::get('active-account', [\App\Http\Controllers\UserController::class, 'activeAccount'])->name('form-active');
Route::post('send-active', [\App\Http\Controllers\EmailController::class, 'active'])->name('send-active');
Route::get('active/{slug}', [\App\Http\Controllers\UserController::class, 'active'])->name('user.active');


//Routes for home
Route::prefix('/')->middleware(['auth', 'first.time.login'])->group(function () {

    //Home page
    Route::get('', [HomeController::class, 'index'])->name('index');

    Route::get('/loadDepartment/{id}', [TicketController::class, 'loadDepartment']);
    Route::get('/loadprolemType/{id}', [TicketController::class, 'loadprolemType']);
    // User
    Route::get('/ManagerLists', [\App\Http\Controllers\UserController::class, 'ManagerLists'])->name('ManagerLists');
    Route::get('/searchUser', [\App\Http\Controllers\UserController::class, 'searchUser'])->name('searchUser');
    Route::get('/select_staff_handle_ticket', [\App\Http\Controllers\UserController::class, 'select_staff_handle_ticket'])->name('select_staff_handle_ticket');


    //Check limit time create ticket of user
    Route::get('checkLimitCreateTicket', [TicketController::class, 'checkLimitCreateTicket'])->name('checkLimitCreateTicket');
    Route::post('/updateDetail/{id}', [TicketController::class, 'updateDetail']);
    Route::put('/rejectTicket/{id}', [TicketController::class, 'rejectTicket']);
    Route::put('/ApprovalTicket/{id}', [TicketController::class, 'ApprovalTicket']);
    Route::put('/SlovedTicket/{id}', [TicketController::class, 'SlovedTicket']);
    Route::put('/requestapprovalTicket/{id}', [TicketController::class, 'requestapprovalTicket']);

    Route::put('finishTicket/{id}', [TicketController::class, 'finishTicket']);
    Route::put('forward-ticket/{id}', [TicketController::class, 'forwardTicket']);


    //sub Task
    Route::get('/checkSubTaskEmpty/{id_ticket}', [SubTaksController::class, 'checkSubTaskEmpty']);
    Route::put('/updateholdingsustaks/{id}', [SubTaksController::class, 'updateholdingsustaks']);
    Route::put('/subtasksapproveds/{id}', [SubTaksController::class, 'subtasksapproveds']);
    Route::put('/cancel_request_subtask/{id}', [SubTaksController::class, 'cancel_request_subtask']);
    Route::put('/done_subtask/{id}', [SubTaksController::class, 'done_subtask']);
    Route::put('/reject_subtask/{id}', [SubTaksController::class, 'reject_subtask']);

    Route::resource('subtasks', SubTaksController::class);

    //Processing
    Route::resource('TaskProcessing', TaskProcessingController::class);

    Route::resource('ticket', TicketController::class);
    Route::get('/updateAvatar', [HomeController::class, 'CreateImagesForAllUser']);


    Route::get('/showMesNoti', [NotificationController::class, 'showMesNoti']);
    Route::put('/readMessengeNotification/{id}', [NotificationController::class, 'readMessengeNotification']);


    Route::get('/logout', '\App\Http\Controllers\Auth\LoginController@logout');
    Route::resource('ticket', 'App\Http\Controllers\TicketController');
    Route::resource('notifications', NotificationController::class);
    Route::post('ticket_offline', [App\Http\Controllers\TicketController::class, 'ticket_offline'])->name('ticket_offline');


    Route::resource('messengers', MessengersController::class);
    Route::resource('conversation', \App\Http\Controllers\ConversationsController::class);


    Route::get('changepass', [UserController::class, 'changepass'])->name('changepass');
    Route::get('/change-password', [PasswordController::class, 'showChangePasswordForm'])->name('change.password');
    Route::post('/change-password', [PasswordController::class, 'changePassword'])->name('change.password.post');

    Route::resource('user', \App\Http\Controllers\UserController::class);
    Route::resource('reports', \App\Http\Controllers\ReportsConroller::class);

    //downloadFile
    Route::get('/downloadFile/{slug}', [\App\Http\Controllers\FileController::class, 'downloadFile']);


    //Other Route
    Route::post('/upload-image', [HomeController::class, 'upload'])->name('tinymce.upload');
    Route::get('/notificationMakeReadAll', [NotificationController::class, 'MakeReadAll'])->name('notificationMakeReadAll');


    Route::get('/radarChart', [ReportsConroller::class, 'radarChart'])->name('radarChart');
    Route::get('/TicketDownTimeChart', [ReportsConroller::class, 'TicketDownTimeChart'])->name('TicketDownTimeChart');
    Route::get('/percentStatusChart', [ReportsConroller::class, 'percentStatusChart'])->name('percentStatusChart');
    Route::get('/TicketDowntimeByIssueChart', [ReportsConroller::class, 'TicketDowntimeByIssueChart'])->name('TicketDowntimeByIssueChart');
    Route::get('/StatsProcessTimeByProblemType', [ReportsConroller::class, 'StatsProcessTimeByProblemType'])->name('StatsProcessTimeByProblemType');
    Route::get('/AvgChartStar', [ReportsConroller::class, 'AvgChartStar'])->name('AvgChartStar');


});
//Route for Admin routes
Route::prefix('admin')->middleware(['auth', 'role:admin|administrator'])->name('admin.')->group(function () {
    Route::get('/', [AdminController::class, 'index'])->name('index');
    Route::get('download-sample-form', [UserController::class, 'downloadSampleForm'])->name('users.download-sample-form');
    Route::get('users/import', [UserController::class, 'importView'])->name('users.importView');
    Route::get('users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('users/import', [UserController::class, 'import'])->name('users.import');
    Route::resource('users', UserController::class);
    Route::resource('factories', FactoriesController::class);
    Route::resource('roles', RolesController::class);
    Route::resource('permissions', PermissionsController::class);
    Route::resource('translate', \App\Http\Controllers\TranslateController::class);
});
