<?php $__env->startSection('page-title', 'Permissions Control'); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card">
            <div class="card-body">
                <div class="card-datatable table-responsive pt-0">
                    <table class="datatables-basic table" id="table_index">
                    </table>
                </div>
            </div>
        </div>
    </div>


    <!-- Extra Large Modal -->
    <div class="modal fade" id="exLargeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <form id="FormID">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel4">Modal title</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="validation"></div>
                        <div class="form-group">
                            <label for="name">Permission</label>
                            <input type="text" name="name" id="name" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <input type="text" name="description" id="description" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="guard_name">Guard name</label>
                            <input type="text" name="guard_name" id="guard_name" value="web" class="form-control" disabled>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        let updateRoute = "<?php echo e(route('admin.permissions.update', '')); ?>";
        let storeRoute = "<?php echo e(route('admin.permissions.store')); ?>";
        let showRoute = "<?php echo e(route('admin.permissions.show', '')); ?>";
        let createRoute = "<?php echo e(route('admin.permissions.create')); ?>";
        let destroyRoute = "<?php echo e(route('admin.permissions.destroy', '')); ?>";

        $(document).ready(function () {
            var table = $("#table_index").DataTable({
                processing: true,
                serverSide: false,
                ajax: {
                    url: createRoute,
                    dataSrc: "",
                },
                dom: '<"card-header flex-column flex-md-row"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                buttons: [
                    {
                        extend: 'collection',
                        className: 'btn btn-label-primary dropdown-toggle me-2',
                        text: '<i class="ti ti-file-export me-sm-1"></i> <span class="d-none d-sm-inline-block">Export</span>',
                        buttons: [
                            {
                                extend: 'print',
                                text: '<i class="ti ti-printer me-1" ></i>Print',
                                className: 'dropdown-item',
                                exportOptions: {columns: [3, 4, 5, 6, 7]}
                            },
                            {
                                extend: 'csv',
                                text: '<i class="ti ti-file-text me-1" ></i>Csv',
                                className: 'dropdown-item',
                                exportOptions: {columns: [3, 4, 5, 6, 7]}
                            },
                            {
                                extend: 'pdf',
                                text: '<i class="ti ti-file-description me-1"></i>Pdf',
                                className: 'dropdown-item',
                                exportOptions: {columns: [3, 4, 5, 6, 7]}
                            },
                            {
                                extend: 'copy',
                                text: '<i class="ti ti-copy me-1" ></i>Copy',
                                className: 'dropdown-item',
                                exportOptions: {columns: [3, 4, 5, 6, 7]}
                            }
                        ]
                    },
                    {
                        text: '<i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block" data-bs-toggle="modal" data-bs-target="#exLargeModal">Add New Record</span>',
                        className: 'create-new btn btn-primary',

                    }
                ],

                columns: [{
                    data: "id",
                    title: "id",
                },
                    {
                        data: "name",
                        title: "name",
                    },
                    {
                        data: "description",
                        title: "description",
                    },
                    {
                        data: "guard_name",
                        title: "Guard name",
                    },
                    {
                        data: "created_at",
                        title: "created_at",
                    },
                    {
                        data: "id",
                        title: "Action",
                        render: function (data) {
                            return (
                                '<button name="btnEdit"  data-id="' +
                                data +
                                '" class="btn btn-success"><i class="fa-solid fa-pen-to-square"></i>Edit</button> <button name="btnDel" data-id="' +
                                data +
                                '" class="btn btn-danger"><i class="fa-solid fa-trash"></i>Del</button>'
                            );
                        },
                    },
                ],
                order: [0, "desc"],
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal({
                            header: function (row) {
                                var data = row.data();
                                return 'Details of ' + data['full_name'];
                            }
                        }),
                        type: 'column',
                        renderer: function (api, rowIdx, columns) {
                            var data = $.map(columns, function (col, i) {
                                return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                    ? '<tr data-dt-row="' +
                                    col.rowIndex +
                                    '" data-dt-column="' +
                                    col.columnIndex +
                                    '">' +
                                    '<td>' +
                                    col.title +
                                    ':' +
                                    '</td> ' +
                                    '<td>' +
                                    col.data +
                                    '</td>' +
                                    '</tr>'
                                    : '';
                            }).join('');

                            return data ? $('<table class="table"/><tbody />').append(data) : false;
                        }
                    }
                },

            });

            $(document).on("submit", '#FormID', function (event) {
                event.preventDefault();
                var data = $(this).serialize();
                var id = $(this).attr("data-id");
                switch (checkFormType()) {
                    case "edit":
                        $.ajax({
                            type: "PUT",
                            url: updateRoute + "/" + id,
                            data: data,
                            success: function (response) {
                                toastr.success(response.message, {
                                    timeOut: 5000,
                                });
                                $('#table_index').DataTable().ajax.reload();
                            },
                            error: function (jqXHR) {
                                showErrors(jqXHR);
                            },
                        });
                        break;
                    //submit create
                    default:
                        $.ajax({
                            url: storeRoute,
                            method: "POST",
                            data: data,
                            success: function (response) {
                                $("#validation")
                                    .empty()
                                    .append(
                                        '<div class="alert alert-success" role="alert">' +
                                        response.message +
                                        "</div>"
                                    );
                                table.ajax.reload();
                            },
                            error: function (jqXHR) {
                                showErrors(jqXHR);
                            },
                        });
                        break;
                }
            });
        });

        function formCreate() {
            $('#FormID input[name="guard_name"]').val("web");
            $('#FormID input[name="name"]').prop("disabled", false);
            $('#FormID input[name="guard_name"]').prop("disabled", true);
        }

        function formUpdate() {
            $('#FormID input[name="name"]').prop("disabled", true);
            $('#FormID input[name="guard_name"]').prop("disabled", true);
        }

        function beforeEdit(response) {

        }
    </script>
    <script src="<?php echo e(asset('js/controlForm.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\admin\permissions.blade.php ENDPATH**/ ?>