<?php $__env->startSection('Page-title', 'Report Page'); ?>

<?php $__env->startSection('Page-css'); ?>
    <link href="https://cdn.datatables.net/v/bs5/dt-2.0.0/datatables.min.css" rel="stylesheet">
    <script src="https://cdn.datatables.net/v/bs5/dt-2.0.0/datatables.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.1/css/buttons.dataTables.min.css">
    <script src="https://cdn.datatables.net/buttons/1.6.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.6.1/js/buttons.html5.min.js"></script>
    <link
        href="https://cdn.datatables.net/v/dt/jszip-3.10.1/dt-2.0.0/b-3.0.0/b-colvis-3.0.0/b-html5-3.0.0/datatables.min.css"
        rel="stylesheet">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script
        src="https://cdn.datatables.net/v/dt/jszip-3.10.1/dt-2.0.0/b-3.0.0/b-colvis-3.0.0/b-html5-3.0.0/datatables.min.js">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="">
            <div>
                <h4 class="font-weight-bold py-3 mb-4">
                    Reports
                </h4>
            </div>
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home"
                        type="button" role="tab" aria-controls="home" aria-selected="true">For Staffs
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button"
                        role="tab" aria-controls="profile" aria-selected="false">For Tickets
                    </button>
                </li>

            </ul>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="name">Dashboard options</h5>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col d-inline" aria-label="select month">
                                                <label for="changeMonthRadarChart">Month</label>
                                                <select id="changeMonthRadarChart" class="form-control">
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 1 ? 'selected' : ''); ?>

                                                        value=1>1</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 2 ? 'selected' : ''); ?>

                                                        value=2>2</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 3 ? 'selected' : ''); ?>

                                                        value=3>3</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 4 ? 'selected' : ''); ?>

                                                        value=4>4</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 5 ? 'selected' : ''); ?>

                                                        value=5>5</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 6 ? 'selected' : ''); ?>

                                                        value=6>6</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 7 ? 'selected' : ''); ?>

                                                        value=7>7</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 8 ? 'selected' : ''); ?>

                                                        value=8>8</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 9 ? 'selected' : ''); ?>

                                                        value=9>9</option>
                                                    <option <?php echo e(\Carbon\Carbon::now()->format('m') == 10 ? 'selected' : ''); ?>

                                                        value=10>10</option>
                                                    <option
                                                        <?php echo e(\Carbon\Carbon::now()->format('m') == 11 ? 'selected' : ''); ?>

                                                        value=11>11</option>
                                                    <option
                                                        <?php echo e(\Carbon\Carbon::now()->format('m') == 12 ? 'selected' : ''); ?>

                                                        value=12>12</option>
                                                </select>
                                            </div>
                                            <div class="col" aria-label="select year">
                                                <label for="selectYearRadar">Year</label>
                                                <select class="form-control" id="selectYearRadar">
                                                    <option value=2024 selected>2024</option>
                                                    <option value=2025>2025</option>
                                                </select>
                                            </div>
                                            <div class="col" aria-label="select factory">
                                                <label for="selectFactoryRadar">Factory</label>
                                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'ticket-sorter')): ?>
                                                    <script>
                                                        console.log();
                                                    </script>
                                                    <?php echo e(Auth::user()->id_factory); ?>

                                                <?php endif; ?>
                                                <select class="form-control" id="selectFactoryRadar">
                                                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'admin')): ?>
                                                        
                                                        <option value="1"
                                                            <?php echo e(Auth::user()->id_factory == '1' ? 'selected' : ''); ?>>
                                                            Alliance One: A1A</option>
                                                        <option value="3"
                                                            <?php echo e(Auth::user()->id_factory == '3' ? 'selected' : ''); ?>>Trax:
                                                            TAC</option>
                                                        <option value="14"
                                                            <?php echo e(Auth::user()->id_factory == '14' ? 'selected' : ''); ?>>Roi
                                                            Et: TRR</option>
                                                        <option value="15"
                                                            <?php echo e(Auth::user()->id_factory == '15' ? 'selected' : ''); ?>>
                                                            Chaiyaphum: TCP/CYP</option>
                                                        <option value="16"
                                                            <?php echo e(Auth::user()->id_factory == '16' ? 'selected' : ''); ?>>Head
                                                            quarter: BKK</option>
                                                        <option value="16"
                                                            <?php echo e(Auth::user()->id_factory == '19' ? 'selected' : ''); ?>>Tans
                                                        </option>
                                                    <?php endif; ?>
                                                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'ticket-sorter')): ?>
                                                        <option value="<?php echo e(Auth::user()->id_factory); ?>" selected>
                                                            <?php echo e(Auth::user()->id_factory); ?>

                                                        </option>
                                                    <?php endif; ?>

                                                </select>

                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row pb-3">
                        <div class="col-8">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="name">Ticket Downtime by Issue Chart</h5>
                                    <div>

                                        <canvas style="width: 100%" id="TicketDownTimeByIssue"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="name">Radar chart</h5>
                                    <div>
                                        <canvas style="width: 100%" id="chartRadar"></canvas>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- path 2 -->
                    <div class="row pb-3">
                        <!-- chart right  -->
                        <div class="col-6 pr-2 ">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h5 class="name">Percent Status Chart</h5>
                                    <table class="table table-bordered" style="width: 100%">
                                        <tr>
                                            <th>Type</th>
                                            <th>Qty</th>
                                            <th>Percent</th>
                                            <th>Ratio</th>

                                        </tr>
                                        <tr>
                                            <td>Done</td>
                                            <td id="totalDoneTotalTable"></td>
                                            <td id="percentDoneTotalTable"></td>
                                            <td id="RatioDone"></td>
                                        </tr>
                                        <tr>
                                            <td>Finish</td>
                                            <td id="totalFinishTotalTable"></td>
                                            <td id="percentFinishTotalTable"></td>
                                            <td id="RatioFinish"></td>
                                        </tr>

                                    </table>

                                    <div>
                                        <canvas style="width: 100%" id="chartSumStatus"></canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-body">
                                    <h5 class="name">Average Rating group by users</h5>
                                    <div>
                                        <canvas style="width: 100%" id="AvgChartStar"></canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="col-6">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h5 class="name">Average TRT and MTTR</h5>
                                    <div>
                                        <canvas style="width: 100%" id="TicketDownTimeChart"></canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="card mb-3">
                                <div class="card-body">
                                    <h5 class="name">Average Count Problem</h5>
                                    <div>
                                        <canvas style="width: 100%" id="chartProblem"></canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-body">
                                    <h5 class="name">StatsProcessTimeByProblemType</h5>
                                    <div>
                                        <canvas style="width: 100%" id="StatsProcessTimeByProblemType"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <div class="card">
                                <div class="card-body">
                                    <table id="table1" class="table nowrap" style="width:100%"></table>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6"></div>
                        <div class="col-6"></div>
                    </div>


                </div>








                

                <script>
                    $(document).ready(function() {

                        LoadChartRadar();
                        loadChartSumStatus();
                        loadTicketDownTimeChart();
                        LoadTicketDowntimeByIssueChart();
                        loadStatsProcessTimeByProblemType();
                        loadAvgChartStar();

                    });

                    let radarChart; // Declare the radarChart variable outside the function
                    let pSumStatusChart;
                    let pTicketDownTimeChart;
                    let pTicketDownTimeByIssue;
                    let pStatsProcessTimeByProblemType;
                    let pAvgChartStar;


                    function loadAvgChartStar() {
                        $.ajax({
                            type: "get",
                            url: "./AvgChartStar",
                            data: {
                                'factory': $('select#selectFactoryRadar').val(),
                            },
                            success: function(response) {


                                AvgChartStar = document.getElementById('AvgChartStar').getContext('2d');
                                if (pAvgChartStar) {
                                    pAvgChartStar.destroy();
                                }

                                pAvgChartStar = new Chart(AvgChartStar, {
                                    type: 'bar',
                                    data: {
                                        labels: response.labels,
                                        datasets: [{
                                                label: 'Issue AVG_staff_star',
                                                data: response.AVG_staff_star,
                                                borderWidth: 1,
                                                //backgroundColor: '#36a2eb',
                                            },
                                            {
                                                label: 'Issue AVG_ticket_star',
                                                data: response.AVG_ticket_star,
                                                borderWidth: 1,
                                                //backgroundColor: '#4bc0c0',
                                            },

                                            {
                                                label: 'Issue TicketCount',
                                                data: response.TicketCount,
                                                borderWidth: 1,
                                                type: 'line'
                                                //backgroundColor: '#4bc0c0',
                                            },



                                        ]
                                    },
                                    options: {
                                        scales: {
                                            x: {
                                                // stacked: true,
                                            },
                                            y: {
                                                // stacked: true
                                            }
                                        }
                                    }
                                });
                            }
                        });

                    }

                    function loadStatsProcessTimeByProblemType() {
                        $.ajax({
                            type: "get",
                            url: "./StatsProcessTimeByProblemType",
                            data: {
                                'year': $('select#selectYearRadar').val(),
                                'factory': $('select#selectFactoryRadar').val(),
                                'type': $('#issueType').val()
                            },
                            success: function(response) {


                                StatsProcessTimeByProblemType = document.getElementById('StatsProcessTimeByProblemType')
                                    .getContext('2d');
                                if (pStatsProcessTimeByProblemType) {
                                    pStatsProcessTimeByProblemType.destroy();
                                }

                                pStatsProcessTimeByProblemType = new Chart(StatsProcessTimeByProblemType, {
                                    type: 'bar',
                                    data: {
                                        labels: response.Issue.labels,
                                        datasets: [{
                                                label: 'Issue MTTR_MeanTimeToRepair',
                                                data: response.Issue.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#36a2eb',
                                                stack: 'Issue',
                                            },
                                            {
                                                label: 'Issue TRT_TicketResponseTime',
                                                data: response.Issue.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#4bc0c0',
                                                stack: 'Issue',
                                            },

                                            {
                                                label: 'Request MTTR_MeanTimeToRepair',
                                                data: response.Request.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#36a2eb',
                                                stack: 'Request',
                                            },
                                            {
                                                label: 'Request TRT_TicketResponseTime',
                                                data: response.Request.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#4bc0c0',
                                                stack: 'Request',
                                            },



                                        ]
                                    },
                                    options: {
                                        scales: {
                                            x: {
                                                stacked: true,
                                            },
                                            y: {
                                                stacked: true
                                            }
                                        }
                                    }
                                });
                            }
                        });

                    }


                    function LoadTicketDowntimeByIssueChart() {
                        $.ajax({
                            type: "get",
                            url: "./TicketDowntimeByIssueChart",
                            data: {
                                'year': $('select#selectYearRadar').val(),
                                'factory': $('select#selectFactoryRadar').val(),
                                'type': $('#issueType').val()
                            },
                            success: function(response) {


                                TicketDownTimeByIssue = document.getElementById('TicketDownTimeByIssue').getContext('2d');
                                if (pTicketDownTimeByIssue) {
                                    pTicketDownTimeByIssue.destroy();
                                }

                                pTicketDownTimeByIssue = new Chart(TicketDownTimeByIssue, {
                                    type: 'bar',
                                    data: {
                                        labels: response.Application.labels,
                                        datasets: [{
                                                label: 'Application MTTR_MeanTimeToRepair',
                                                data: response.Application.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#36a2eb',
                                                stack: 'Application',
                                            },
                                            {
                                                label: 'Application TRT_TicketResponseTime',
                                                data: response.Application.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#4bc0c0',
                                                stack: 'Application',
                                            },

                                            //devices
                                            {
                                                label: 'Devices MTTR_MeanTimeToRepair',
                                                data: response.Devices.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#e2d212',
                                                stack: 'Devices',
                                            },
                                            {
                                                label: 'Devices TRT_TicketResponseTime',
                                                data: response.Devices.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#7076fc',
                                                stack: 'Devices',
                                            },

                                            //ERP Software
                                            {
                                                label: 'ERP Software MTTR_MeanTimeToRepair',
                                                data: response.ERPSoftware.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#e2d212',
                                                stack: 'ERP Software',
                                            },
                                            {
                                                label: 'ERP Software TRT_TicketResponseTime',
                                                data: response.ERPSoftware.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#7076fc',
                                                stack: 'ERP Software',
                                            },

                                            //Network
                                            {
                                                label: 'Network MTTR_MeanTimeToRepair',
                                                data: response.Network.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#e2d212',
                                                stack: 'Network',
                                            },
                                            {
                                                label: 'Network TRT_TicketResponseTime',
                                                data: response.Network.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#7076fc',
                                                stack: 'Network',
                                            },

                                            //Other
                                            {
                                                label: 'Other MTTR_MeanTimeToRepair',
                                                data: response.Other.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                //backgroundColor: '#33aaee',
                                                stack: 'Other',
                                            },
                                            {
                                                label: 'Other TRT_TicketResponseTime',
                                                data: response.Other.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                //backgroundColor: '#4455dd',
                                                stack: 'Other',
                                            }
                                        ]
                                    },
                                    options: {
                                        scales: {
                                            x: {
                                                stacked: true,
                                            },
                                            y: {
                                                stacked: true
                                            }
                                        }
                                    }
                                });
                            }
                        });

                    }



                    function LoadChartRadar() {
                        $.ajax({
                            type: "get",
                            url: "./radarChart",
                            data: {
                                'month': $('select#changeMonthRadarChart').val(),
                                'factory': $('#selectFactoryRadar').val(),
                                'year': $('#selectYearRadar').val()
                            },
                            success: function(response) {
                                const chartRadar = document.getElementById('chartRadar').getContext('2d');

                                const dataRadarChart = {
                                    labels: response.radarChart.labels,
                                    datasets: [{
                                        label: 'Staff',
                                        data: response.radarChart.staffData,
                                        fill: true,
                                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                                        borderColor: 'rgb(255, 99, 132)',
                                        pointBackgroundColor: 'rgb(255, 99, 132)',
                                        pointBorderColor: '#fff',
                                        pointHoverBackgroundColor: '#fff',
                                        pointHoverBorderColor: 'rgb(255, 99, 132)'
                                    }, {
                                        label: 'Rating',
                                        data: response.radarChart.ratingData,
                                        fill: true,
                                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                                        borderColor: 'rgb(54, 162, 235)',
                                        pointBackgroundColor: 'rgb(54, 162, 235)',
                                        pointBorderColor: '#fff',
                                        pointHoverBackgroundColor: '#fff',
                                        pointHoverBorderColor: 'rgb(54, 162, 235)'
                                    }]
                                };

                                if (radarChart) {
                                    radarChart.destroy(); // Destroy the existing chart instance
                                }

                                radarChart = new Chart(chartRadar, {
                                    type: 'radar',
                                    data: dataRadarChart,
                                    options: {
                                        scales: {
                                            r: { // 'r' for radial scale in radar charts
                                                beginAtZero: false,
                                                min: 0.5,
                                                max: 5,
                                                stepSize: {
                                                    stepSize: 1
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                        });
                    }
                    $('select#changeMonthRadarChart,#selectYearRadar,#selectFactoryRadar').change(function() {
                        LoadChartRadar();
                        loadChartSumStatus();
                        loadTicketDownTimeChart();
                        LoadTicketDowntimeByIssueChart();

                    });

                    $('select#issueType').change(function() {
                        LoadTicketDowntimeByIssueChart()
                    });


                    function loadChartSumStatus() {
                        $.ajax({
                            type: "get",
                            url: "./percentStatusChart",
                            data: {
                                'year': $('select#selectYearRadar').val(),
                                'factory': $('select#selectFactoryRadar').val()
                            },
                            success: function(response) {

                                $('#totalDoneTotalTable').text(response.totalTicketDone)
                                $('#totalFinishTotalTable').text(response.totalTicketFinish)
                                $('#percentDoneTotalTable').text(parseFloat(response.totalTicketDone / response
                                    .totalTicket * 100).toFixed(2))
                                $('#percentFinishTotalTable').text(parseFloat(response.totalTicketFinish / response
                                    .totalTicket * 100).toFixed(2))

                                let totalRatio = response.totalTicketDone + response.totalTicketFinish

                                $('#RatioDone').text(parseFloat(response.totalTicketDone / totalRatio).toFixed(2))


                                $('#RatioFinish').text(parseFloat(response.totalTicketFinish / totalRatio).toFixed(2))

                                sumStatusChart = document.getElementById('chartSumStatus').getContext('2d');
                                if (pSumStatusChart) {
                                    sumStatusChart.destroy();
                                }

                                pSumStatusChart = new Chart(sumStatusChart, {
                                    type: 'bar',
                                    data: {
                                        labels: response.labels,
                                        datasets: [{
                                                label: 'Done',
                                                data: response.ticketDoneData,
                                                borderWidth: 1,
                                                backgroundColor: '#36a2eb',
                                                stack: 'Stack 0',
                                            },
                                            {
                                                label: 'Finish',
                                                data: response.ticketFinishData,
                                                borderWidth: 1,
                                                backgroundColor: '#4bc0c0',
                                                stack: 'Stack 0',
                                            },



                                        ]
                                    },
                                    options: {
                                        scales: {
                                            x: {
                                                stacked: true,
                                            },
                                            y: {
                                                stacked: true
                                            }
                                        }
                                    }
                                });
                            }
                        });



                    }



                    function loadTicketDownTimeChart() {

                        $.ajax({
                            type: "get",
                            url: "./TicketDownTimeChart",
                            data: {
                                'year': $('select#selectYearRadar').val(),
                                'factory': $('select#selectFactoryRadar').val()
                            },
                            success: function(response) {

                                const TicketDownTimeChart = document.getElementById('TicketDownTimeChart').getContext('2d');

                                if (pTicketDownTimeChart) {
                                    pTicketDownTimeChart.destroy(); // Destroy the existing chart instance
                                }

                                pTicketDownTimeChart = new Chart(TicketDownTimeChart, {
                                    type: 'bar',
                                    data: {
                                        labels: response.radarChart.labels,
                                        datasets: [{
                                                label: 'MTTR (Mean Time To Repair Miniute)',
                                                data: response.radarChart.MTTR_MeanTimeToRepair,
                                                borderWidth: 1,
                                                backgroundColor: '#36a2eb',
                                                stack: 'Stack 0',
                                            },
                                            {
                                                label: 'TRT (Ticket Response Miniute)',
                                                data: response.radarChart.TRT_TicketResponseTime,
                                                borderWidth: 1,
                                                backgroundColor: '#4bc0c0',
                                                stack: 'Stack 0',
                                            },



                                        ]
                                    },
                                    options: {
                                        scales: {
                                            x: {
                                                stacked: true,
                                            },
                                            y: {
                                                stacked: true
                                            }
                                        }
                                    }
                                });
                            }
                        });




                    }
                </script>


                



                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">

                </div>
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                    <div class="row">
                        <div class="col-6">

                        </div>
                        <div class="col-6">
                            <div class="card">
                                <div class="card-body">
                                    <table id="table2" class="table nowrap " style="width:100%"></table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $('#table1').DataTable({
            scrollY: '500px',
            scrollCollapse: true,
            data: <?php echo json_encode($table1); ?>,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'excel', 'pdf'
            ],
            columns: [{
                    data: 'username',
                    title: 'username'
                },
                {
                    data: 'fullname',
                    title: 'fullname'
                },
                {
                    data: 'factories',
                    title: 'factories'
                },
                {
                    data: 'avg_star',
                    title: 'avg_star',
                    render: (data, type, row) => {
                        if (data === null) {
                            return '_'
                        }
                        return parseFloat(data).toFixed(2)
                    }
                },
                {
                    data: 'ticket_finish_count',
                    title: 'ticket_finish_count'
                },
            ]
        });

        $('#table2').DataTable({
            scrollY: '500px',
            scrollCollapse: true,
            data: <?php echo json_encode($table2); ?>,
            dom: 'Bfrtip',
            buttons: [
                'copy', 'excel', 'pdf'
            ],
            columns: [{
                    data: 'id',
                    title: 'id'
                },
                {
                    data: 'date_send',
                    title: 'date_send'
                },
                {
                    data: 'factory',
                    title: 'factory'
                },
                {
                    data: 'department',
                    title: 'department'
                },
                {
                    data: 'type',
                    title: 'type'
                },
                {
                    data: 'title',
                    title: 'title'
                },
                {
                    data: 'status',
                    title: 'status'
                },
                {
                    data: 'staff_star',
                    title: 'staff_star',
                    render: (data, type, row) => {
                        if (data === null) {
                            return '_'
                        }
                        return parseFloat(data).toFixed(2)
                    }
                },
                {
                    data: 'rating',
                    title: 'rating',
                    render: (data, type, row) => {
                        console.log(data)
                        if (data === null) {
                            return '_'
                        }
                        return parseFloat(data).toFixed(2)
                    }
                },
                {
                    data: 'UserFullName',
                    title: 'UserFullName'
                },
            ]
        });

        const ctx = document.getElementById('myChart');
        const ctx1 = document.getElementById('chartProblem');
        var chartData = <?php echo json_encode($chartData, 15, 512) ?>;


        new Chart(ctx, {
            type: 'bar',
            data: chartData,
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });


        var chartProblem = <?php echo json_encode($chartProblem, 15, 512) ?>;
        const labels2 = [...new Set(chartProblem.map(item => item.contry))];
        const problems2 = [...new Set(chartProblem.map(item => item.problem))];
        const counts2 = chartProblem.map(item => item.count);

        // Tạo một mảng chứa các dataset cho từng vấn đề
        const datasets = problems2.map((problem, index) => {
            // Lọc dữ liệu cho vấn đề hiện tại
            const data = chartProblem.filter(item => item.problem === problem).map(item => item.count);

            // Trả về một dataset mới
            return {
                label: problem,
                data: data,
                borderWidth: 1
            };
        });

        // Tạo một biểu đồ mới
        new Chart(ctx1, {
            type: 'bar',
            data: {
                labels: labels2,
                datasets: datasets
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\reports.blade.php ENDPATH**/ ?>