<?php $__env->startSection('page-title', 'Users Settings'); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-fluid">
        <div class="col6">
            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="alert alert-danger"><?php echo e($error); ?></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <?php if(session('message')): ?>
                <h6 class="alert alert-success">
                    <?php echo e(session('message')); ?>

                </h6>
            <?php endif; ?>
            <form action="<?php echo e(route('admin.users.update', ['user' => $users_edit['id']])); ?>" method="POST">  
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Edit User</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" id="name" name="name" value="<?php echo e($users_edit['username']); ?>"
                                class="form-control" disabled>
                        </div>
                        <div class="form-group">
                            <label for="fullname">Fullname</label>
                            <input type="text" id="fullname" name="fullname" value="<?php echo e($users_edit['fullname']); ?>"
                                class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="role">Role</label>
                            <select name="role" id="role" class="form-control">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role['id']); ?>"
                                    <?php echo e($users_edit['roles'][0]['id'] === $role['id'] ? 'selected' : ''); ?> 
                                    ><?php echo e($role['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="factories">Factories</label>
                            <select name="factories" id="fatories_list" class="form-control">
                                <?php $__currentLoopData = $factories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($factory['id']); ?>"
                                        <?php echo e($users_edit['id_factory'] == $factory['id'] ? 'selected' : ''); ?>>
                                        <?php echo e($factory['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="email" name="email" class="form-control" value="<?php echo e($users_edit['email']); ?>">
                        </div>
                        <div class="form-group">
                            <label for="name">Departements</label>
                            <select id="departments_list" class="form-control" name="department">
                                <option value="" selected>-- Chose Department --</option>

                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option data-factory="<?php echo e($department['id']); ?>" value="<?php echo e($department['id']); ?>"
                                        <?php echo e($users_edit['id_dept']== $department['id'] ? 'selected' : ''); ?>>
                                        <?php echo e($department['name']); ?> :
                                        <?php echo e($department['nameEn']); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save</button>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary"><i
                                class="fa-solid fa-arrow-left"></i> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        $('#fatories_list').change(function () {
            var factoryId = $(this).val();
            if (factoryId) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(url('./loadDepartment')); ?>/" + factoryId,
                    success: function (res) {
                        var datas = res['Departments']

                        //foreach using jquery
                        $("#departments_list").empty();
                        $.each(datas, function (key, value) {
                            $("#departments_list").append('<option value="' + value.id + '">' + value.nameVi + '</option>');
                        });


                    }
                });
            } else {
                $("#departments_list").empty();
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\admin\editUser.blade.php ENDPATH**/ ?>