<?php $__env->startSection('page-title', 'Home'); ?>

<?php $__env->startSection('content'); ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create ticket')): ?>
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">My Process</h3>
            </div>
            <div class="card-body">
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa-solid fa-plus"></i> Problem/Request
                </button>
                <!-- Modal add -->
                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-xl" role="document">
                        <form action="" id="addFrom" novalidate>
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Add Issue/Request</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="d-flex justify-content-between">
                                        <div class="form-group">
                                            <select name="problem" class="form-control" required>
                                                <option value="problem">Problem</option>
                                                <option value="Request">Request</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <select name="factories" class="form-control" required>
                                                <option value="">Choose localtion</option>
                                                <?php $__currentLoopData = $data['factories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($factory->id); ?>"><?php echo e($factory->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <select name="department" class="form-control" required>
                                                <?php $__currentLoopData = $data['departments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <select name="type" class="form-control" required>
                                                <option>Type</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <input name="date" type="date" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="justify-content-between">
                                        <div class="form-group">
                                            <label>Title</label>
                                            <input name="title" type="text" class="form-control" placeholder="Enter ...">
                                        </div>
                                    </div>
                                    <div class="justify-content-between">
                                        <textarea id="myTextarea" name="content" required></textarea>
                                    </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Send</button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="">
                <table class="table table-hover table-bordered text-nowrap mt-2" style="width: 100%" id="TableProcess">
                </table>
            </div>
        </div>
    <?php endif; ?>

    

    <div class="modal fade" id="modalComment" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="false"
        data-backdrop="static">
        <div class="modal-dialog modal-dialog-centered modal-bottom modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Comment</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <textarea id="myTextarea" required></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" id="sentReply" class="btn btn-primary" data-dismiss="modal"><i
                            class="fas fa-paper-plane"></i> Send</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal TicketDetailLabel -->
    <div class="modal fade" id="modalTicketDetail" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTicketDetailLabel">Modal title</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="ticketInfo">
                    <!-- Chat here -->
                </div>
                <div class="modal-footer">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reply ticket')): ?>
                        <button type="button" class="btn btn-primary" id="replyButton">Reply</button>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reject ticket')): ?>
                        <button type="button" class="btn btn-danger" id="stopButton">Reject</button>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('solved ticket')): ?>
                        <button type="button" class="btn btn-danger" id="stopButton">Solved Ticket</button>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('finish ticket')): ?>
                        <button type="button" class="btn btn-success" id="finishButton">Finish</button>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            tinymce.init({
                selector: 'textarea#myTextarea',
                plugins: 'fullscreen autolink lists link image charmap preview anchor',
                toolbar: 'fullscreen | undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                images_upload_url: '<?php echo e(route('tinymce.upload')); ?>',
                images_upload_base_path: '',
                images_upload_credentials: false, //
                images_upload_headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            var table = $('#TableProcess').DataTable({
                destroy: true,
                processing: true,
                select: true,
                ajax: {
                    url: "<?php echo e(route('ticket.index')); ?>",
                    type: "GET",
                    dataSrc: "",
                },
                columns: [{
                        data: "id",
                        title: '#',
                        render: function(data) {
                            return '<a class="btn btn-primary" href="/ticket/'+data+'"">View</a>';
                        }
                    },
                    {
                        data: "type",
                        title: 'Type'
                    },
                    {
                        data: "factories.name",
                        title: 'Factory'
                    },
                    {
                        data: "department.name",
                        title: 'Location'
                    },
                    {
                        data: "status",
                        title: 'Status',
                        render: function(data) {
                            return makeBageTag(data)
                        }
                    },
                    {
                        data: "created_by.fullname",
                        title: 'Sender',
                        render: function(data) {
                            return makeBageTag(data)
                        }
                    },
                    {
                        data: "title",
                        title: 'Title'
                    },
                    {
                        data: "accepted_by.fullname",
                        title: 'Accept by'
                    },
                    {
                        data: "done_by.fullname",
                        title: 'Done by'
                    },
                    {
                        data: "rating",
                        title: 'Rating',
                        render: function(data) {
                            return (data == null) ?
                                '<div class="spinner-grow spinner-grow-sm" role="status"><span class="sr-only">Loading...</span></div>' :
                                data
                        }
                    },
                ],
            })
            $('select[name="problem"]').change(function() {
                selectType = $('select[name="type"]');
                selectType.empty();
                if ($(this).val() == "problem") {
                    selectType.append('<option value="Network">Network</option>');
                    selectType.append('<option value="Application">Application</option>');
                    selectType.append('<option value="Database">Database</option>');
                    selectType.append('<option value="Devices">Devices</option>');
                } else {
                    selectType.append('<option value="grant_permissions">Grant permissions</option>');
                    selectType.append('<option value="change_data">Change Data</option>');
                    selectType.append('<option value="query_data">Query Data</option>');
                }
            })
            //Submit form add
            $('#addFrom').on('submit', function(e) {
                var formData = $(this).serialize();
                $.ajax({
                    url: "<?php echo e(route('ticket.store')); ?>",
                    type: "POST",
                    data: formData,
                    success: function(response) {
                        toastr.success(response);
                        table.ajax.reload(false);
                    },
                    error: function(data) {
                        var obj = JSON.parse(data
                            .responseText); // Chuyển đổi JSON thành đối tượng JavaScript
                        var errors = obj.errors;
                        console.log(errors);
                        toastr.error(errors.title)


                    }

                });
                e.preventDefault();
            })
            //View Ticket
        });
        $(document).on('click', 'button[name="viewTicket"]', function() {
            var ticketID = $(this).val();
            var url = "<?php echo e(route('ticket.show', ':id')); ?>"; // Đảm bảo bạn có :id trong route URL
            url = url.replace(':id', ticketID); // Thay thế :id bằng giá trị biến ticketId
            $.ajax({
                type: "GET",
                url: url,
                success: function(response) {
                    console.log(response);
                    var modalTicket = new bootstrap.Modal(document.getElementById('modalTicketDetail'))
                    modalTicket.show()
                    var modalEditor = new bootstrap.Modal(document.getElementById('modalComment'))
                    tinymce.get("myTextarea").setContent('');

                    //off all events when reload modal
                    $('#replyButton').off('click');
                    $('#replyButton').click(function() {
                        modalEditor.show()

                        $('#sentReply').off('click');
                        $('#sentReply').click(function() {
                            var myContent = tinymce.get("myTextarea").getContent();
                            $.ajax({
                                type: "post",
                                url: "url",
                                data: "data",
                                dataType: "dataType",
                                success: function(response) {

                                }
                            });
                        });

                    })
                    $('h5#modalTicketDetailLabel').text('Ticket: ' + response.title);
                    $('#ticketInfo').empty();
                    var chatMessage = "";
                    ticket_details = response.ticket_details;
                    ticket_details.forEach(element => {
                        chatMessage += `
                                        <div class="direct-chat-msg ${element.user_id == myID ? 'right' : ''}">
                                        <div class="direct-chat-infos clearfix">
                                            <span class="direct-chat-name float-${element.user_id == myID ? 'right' : 'left'}">${element.user_create.fullname}</span>
                                            <span class="direct-chat-timestamp float-${element.user_id == myID ? 'left' : 'right'}">${element.created_at}</span>
                                        </div>
                                        <img class="direct-chat-img" src="https://images.freeimages.com/fic/images/icons/573/must_have/256/user.png?fmt=webp&w=350" alt="message user image">
                                        <div class="direct-chat-text bg-${element.user_id == myID ? 'primary' : ''}">
                                            ${element.contentData}
                                        </div>
                                    </div>
                                `;
                    });
                    $('#ticketInfo').append('<div class="direct-chat-messages">' + chatMessage +
                        '</div>');
                },
                error: function(error) {
                    toastr.error(error)
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\home_old.blade.php ENDPATH**/ ?>