<?php $__env->startSection('page-title', 'User Control'); ?>

<?php $__env->startSection('content'); ?>
    <!-- CSS only -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-+0n0xVW2eSR5Zmz9+Xu5B/w6xZ3Z6Vr1z9q0w2X+X7ZxineVRqF9RvA4gJwZxg2I" crossorigin="anonymous">

    <!-- JavaScript Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-4Yf5PfX+U5zOJvZ2J+5+JF8n5T+Jz7+oq6w5vZv0W6p4+8+X5R5+1J6c0d+4Zwz9" crossorigin="anonymous">
    </script>

    <div class="container-fluid">

        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header ui-sortable-handle" style="cursor: move;">
                <h3 class="card-title">
                    <i class="fas fa-user mr-1"></i>
                    User lists
                </h3>
                <div class="card-tools">
                    <!-- Button trigger modal -->
                    <a type="button" class="btn btn-primary" href="<?php echo e(Route('admin.users.create')); ?>">
                        Create new user
                    </a>
                    <a type="button" class="btn btn-primary" href="<?php echo e(Route('admin.users.importView')); ?>">
                        Import User
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Modal -->
                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
                     aria-labelledby="exampleModalLabel"
                     aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Create new user</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo e($users->links('pagination.bootstrap-4')); ?>

                <div class="row">
                    <div class="col-md-6">
                        <form action="<?php echo e(route('admin.users.index')); ?>" method="GET">
                            <div class="input-group mb-3">
                                <input type="text" class="form-control" placeholder="Search like {name} or like {id}"
                                       name="search" value="<?php echo e($search ?? request()->query('search')); ?>">
                                <select class="form-control" name='factory'>
                                    <?php $__currentLoopData = $Factories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($factory->id); ?>"
                                                <?php if(isset($s_factory) && $s_factory == $factory->id): ?> selected
                                                <?php elseif($factory->id == auth()->user()->id_factory): ?> selected <?php endif; ?>>
                                            <?php echo e($factory->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="submit">Search</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <table class="table table-bordered table-hover" id="table_user">
                    <thead class="thead-dark">
                    <tr>
                        <th>ID</th>
                        <th>Employee ID</th>
                        <th>Name</th>
                        <th>Factory</th>
                        <th>Role</th>
                        <th>Permision</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody class="table-group-divider">
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($user->id); ?></td>
                            <td><?php echo e($user->username); ?></td>
                            <td>
                                <?php echo e($user->fullname); ?>

                            </td>
                            <td>
                                <?php echo e($user->factories['name']); ?>

                            </td>
                            <td>
                                <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-primary"><?php echo e($role->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-primary"><?php echo e($permission->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td class="d-flex justify-content-around align-items-center">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add user')): ?>
                                    <a href="<?php echo e(route('admin.users.edit', ['user' => $user->id])); ?>"
                                       class="btn btn-success"><i class="fa-solid fa-user-pen"></i> Edit</a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete user')): ?>
                                    <form id="form-delete-user" method="POST"
                                          action="<?php echo e(route('admin.users.destroy', ['user' => $user->id])); ?>"
                                          style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger" id="delete_user"><i
                                                class="fa-solid fa-user-times"></i>
                                            Delete
                                        </button>
                                    </form>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ban user')): ?>
                                    <a href="<?php echo e(route('admin.users.edit', ['user' => $user->id])); ?>"
                                       class="btn btn-secondary"><i class="fa-solid fa-ban"></i> Ban</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($users->links('pagination.bootstrap-4')); ?>

            </div>
        </div>
    </div>


    <script>
        $(document).on('submit', '#form-delete-user', function (e) {
            e.preventDefault();
            var form = this; // Store the form element

            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit(); // Submit the form
                }
            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\admin\user.blade.php ENDPATH**/ ?>