<!-- resources/views/auth/change-password.blade.php -->



<?php $__env->startSection('Page-title', 'Change Password'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="py-3 mb-4 pt-5"><span class="text-muted fw-light"></span>Change Password</h4>

        <div class="row">
            <div class="col-12">
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                <?php if(session('errors')): ?>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert alert-danger"><?php echo e($error); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if(session('warning')): ?>
                    <div class="alert alert-warning"><?php echo e(session('warning')); ?></div>
                <?php endif; ?>

                <form action="<?php echo e(route('change.password.post')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="form-group position-relative">
                        <label for="password">New Password</label>
                        <small class="text-danger"
                               title="min 12 characters, at least one uppercase letter, one lowercase letter, one number and one special character">
                            (*) </small>
                        <input type="password" name="password" class="form-control" id="password"
                               placeholder="New Password" required>
                        <i class="fa fa-eye position-absolute" id="togglePassword"
                           style="top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer;"></i>
                    </div>

                    <div class="form-group position-relative">
                        <label for="password_confirmation"><?php echo e(translate('user.Confirm Password')); ?></label>
                        <small class="text-danger"
                               title="min 12 characters, at least one uppercase letter, one lowercase letter, one number and one special character">
                            (*) </small>
                        <input type="password" name="password_confirmation" class="form-control"
                               id="password_confirmation" placeholder="Confirm Password" required>
                        <i class="fa fa-eye position-absolute" id="togglePasswordConfirm"
                           style="top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer;"></i>
                    </div>

                    <button type="submit" class="btn btn-primary mt-2"><?php echo e(translate('user.Change')); ?></button>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const togglePassword = document.querySelector("#togglePassword");
            const password = document.querySelector("#password");
            const togglePasswordConfirm = document.querySelector("#togglePasswordConfirm");
            const passwordConfirm = document.querySelector("#password_confirmation");

            // Toggle visibility for New Password
            togglePassword.addEventListener("click", function () {
                const type = password.getAttribute("type") === "password" ? "text" : "password";
                password.setAttribute("type", type);
                this.classList.toggle("fa-eye-slash");
            });

            // Toggle visibility for Confirm Password
            togglePasswordConfirm.addEventListener("click", function () {
                const type = passwordConfirm.getAttribute("type") === "password" ? "text" : "password";
                passwordConfirm.setAttribute("type", type);
                this.classList.toggle("fa-eye-slash");
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\user\changepass.blade.php ENDPATH**/ ?>