<?php $__env->startSection('page-title', 'Ticket'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="card direct-chat direct-chat-primary">
            <div class="card-header ui-sortable-handle " style="cursor: move;">
                <h3 class="card-title"><?php echo e($ticket->title); ?></h3>
                <div class="card-tools">
                    <span title="3 New Messages" class="badge badge-primary">3</span>
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" title="Contacts" data-widget="chat-pane-toggle">
                        <i class="fas fa-comments"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="card-body">

                <div class="direct-chat-messages" style="height:400px">
                    <?php $__currentLoopData = $ticket->ticketDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="direct-chat-msg <?php echo e($detail->user_id == Auth::user()->id ? 'right' : 'left'); ?>">
                            <div class="direct-chat-infos clearfix">
                                <span
                                    class="direct-chat-name float-<?php echo e($detail->user_id == Auth::user()->id ? 'right' : 'left'); ?>"><?php echo e($detail->UserCreate->fullname); ?></span>
                                <span
                                    class="direct-chat-timestamp float-<?php echo e($detail->user_id == Auth::user()->id ? 'left' : 'right'); ?>"><?php echo e($detail->UserCreate->created_at); ?></span>
                            </div>
                            <img class="direct-chat-img"
                                src="https://images.freeimages.com/fic/images/icons/573/must_have/256/user.png?fmt=webp&w=350"
                                alt="message user image">
                            <div class="direct-chat-text">
                                <?php echo $detail->contentData; ?>

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="card-footer">
                <textarea id="myTextarea" cols="3" required></textarea>
                <div class="input-group">
                    <span class="input-group-append">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reply ticket')): ?>
                            <button type="button" class="btn btn-primary" id="replyButton"> <?php echo e(__('ticket.Reply')); ?></button>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reject ticket')): ?>
                            <button type="button" class="btn btn-danger" id="stopButton">Reject</button>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('solved ticket')): ?>
                            <button type="button" class="btn btn-danger" id="solvedButton">Solved Ticket</button>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('finish ticket')): ?>
                            <button type="button" class="btn btn-success" id="finishButton">Finish</button>
                        <?php endif; ?>

                    </span>
                </div>
            </div>
        </div>
    </div>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            tinymce.init({
                selector: 'textarea#myTextarea',
                plugins: 'fullscreen autolink lists link image charmap preview anchor',
                toolbar: 'fullscreen | undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                images_upload_url: '<?php echo e(route('tinymce.upload')); ?>',
                images_upload_base_path: '', // Thư mục gốc cho ảnh đã tải lên
                images_upload_credentials: false, //
                images_upload_headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('#replyButton').click(function() {
                var myContent = tinymce.get("myTextarea").getContent();
                console.log(myContent);
                $.ajax({
                    type: "PUT",
                    url: "<?php echo e(route('ticket.update', ['ticket' => $ticket->id])); ?>",
                    data: {
                        content: myContent
                    },
                    success: function(response) {
                        tinymce.get("myTextarea").setContent('');
                        location.reload();
                    },
                    error: function(xhr, status, error) {
                        console.log(status);
                        var response = JSON.parse(xhr.responseText);
                        response.errors.content.forEach(element => {
                            toastr[status](element);
                        });

                    }

                });
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\ticket.blade.php ENDPATH**/ ?>