<?php $__env->startSection('page-title', 'Create User'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mt-5">
        <div class="col-6">
            <form action="<?php echo e(Route('admin.users.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>
                <?php if($errors->any()): ?>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert alert-danger d-flex align-items-center" role="alert">
                            <span class="alert-icon text-danger me-2">
                                <i class="ti ti-ban ti-xs"></i>
                            </span>
                            <?php echo e($error); ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if(session('error')): ?>
                    <div class="alert alert-danger d-flex align-items-center" role="alert">
                        <span class="alert-icon
                                    text-success me-2">
                            <i class="ti ti-check ti-xs"></i>
                        </span>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session('success')): ?>
                    <div class="alert alert-success d-flex align-items-center" role="alert">
                        <span class="alert-icon
                                    text-success me-2">
                            <i class="ti ti-check ti-xs"></i>
                        </span>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <div class="card">

                    <div class="card-header">
                        <h5 class="card-title">Create User</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Username([a-zA-Z0-9_])</label>
                            <input type="text" id="username" name="username" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Full name</label>
                            <input type="text" id="fullname" name="fullname" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Passwords (required|min:6|max:255)</label>
                            <input type="password" id="password" name="password" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Re-Passwords</label>
                            <input type="password" id="re-password" name="re-password" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Role</label>
                            <select name="role" id="role" class="form-control" required>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">Factory</label>
                            <select name="factory" id="factory" class="form-control" required>
                               
                                <?php $__currentLoopData = $factories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($factory->id); ?>"><?php echo e($factory->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">Deperment</label>
                            <select name="department" id="department" class="form-control" required>
                                <option value="">Please choose Factory first</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">Sesion</label>
                            <select name="section" id="section" class="form-control" required>
                                <option value="">Please choose Sesion</option>
                                <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($session->id); ?>"><?php echo e($session->contry->name); ?> - <?php echo e($session->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name">positions</label>
                            <select name="position" id="position" class="form-control" required>
                                <option value="">Please choose positions</option>
                                <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($position->id); ?>"><?php echo e($position->contry->name); ?> -
                                        <?php echo e($position->position_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="card-footer d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary m-1">Create</button>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary m-1">Back</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>




<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>

    $('#factory,#department, #section, #position').select2();

    $('#factory').change(function () {
        var factoryId = $(this).val();
        if (factoryId) {
            $.ajax({
                type: "GET",
                url: "<?php echo e(url('./loadDepartment')); ?>/" + factoryId,
                success: function (res) {
                    var datas = res['Departments']

                    //foreach using jquery
                    $("#department").empty();
                    $.each(datas, function (key, value) {
                        $("#department").append('<option value="' + value.id + '">' + value
                            .nameVi + '</option>');
                    });


                }
            });
        } else {
            $("#department").empty();
        }
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\admin\createUser.blade.php ENDPATH**/ ?>