<?php $__env->startSection('Page-title', 'User Profile'); ?>

<?php $__env->startSection('Page-css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="py-3 mb-4 pt-5"><span class="text-muted fw-light">User Profile /</span> Profile</h4>

        <!-- Header -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="user-profile-header d-flex flex-column flex-sm-row text-sm-start text-center mb-4">
                        <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                            <img
                                src="<?php echo e(asset($user->avatar_url)); ?>"
                                alt="user image"
                                class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img"/>
                        </div>
                        <div class="flex-grow-1 mt-3 mt-sm-5">
                            <div
                                class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-4 flex-md-row flex-column gap-4">
                                <div class="user-profile-info">
                                    <h4><?php echo e($user->fullname); ?></h4>
                                    <ul
                                        class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">

                                        <li class="list-inline-item d-flex gap-1">
                                            <i class="ti ti-calendar"></i> Joined <?php echo e($user->created_at ?? ''); ?>

                                        </li>
                                    </ul>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/ Header -->

        <!-- Navbar pills -->
        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-pills flex-column flex-sm-row mb-4">





                    

                </ul>
            </div>
        </div>
        <!--/ Navbar pills -->

        <!-- User Profile Content -->
        <div class="row">
            <div class="col-xl-4 col-lg-5 col-md-5">
                <!-- About User -->
                <div class="card mb-4">
                    <div class="card-body">
                        <small class="card-text text-uppercase">About</small>
                        <ul class="list-unstyled mb-4 mt-3">
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-user text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Full Name:</span> <span><?php echo e($user->fullname ?? ''); ?></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-check text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Status:</span> <span>Active</span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-crown text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Role:</span> <span><?php echo e($user->getRoleNames()[0] ?? ''); ?></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-file-description text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Language:</span> <span><?php echo e($user->Countries['code'] ?? ''); ?></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-flag text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Country:</span> <span><?php echo e($user->Countries['name_eng'] ?? ''); ?></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-flag text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Factory:</span> <span>
                                    <?php if(isset($user) && isset($user->Factories) && isset($user->Factories['name'])): ?>
                                    <?php echo e($user->Factories['name'] ?? ''); ?>

                                    <?php endif; ?>
                                </span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-file-description text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Department:</span> <span>
                                    <?php if(isset($user) && isset($user->Departments) && isset($user->Departments['nameEn'])): ?>
                                    <?php echo e($user->Departments['nameEn'] ?? ''); ?>

                                    <?php endif; ?>
                                </span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-file-description text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Section:</span> <span>
                                    <?php if(isset($user) && isset($user->Sections) && isset($user->Sections['name'])): ?>
                                    <?php echo e($user->Sections['name'] ?? ''); ?>

                                    <?php endif; ?>
                                </span>
                            </li>

                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-file-description text-heading"></i
                                ><span class="fw-medium mx-2 text-heading">Position:</span> <span>
                                    <?php if(isset($user) && isset($user->Positions) && isset($user->Positions['position_name'])): ?>
                                    <?php echo e($user->Positions['position_name'] ?? ''); ?>

                                    <?php endif; ?>
                                </span>
                            </li>
                        </ul>




                        <small class="card-text text-uppercase">Contacts</small>
                        <ul class="list-unstyled mb-4 mt-3">





                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-mail"></i><span class="fw-medium mx-2 text-heading">Email:</span>
                                <span><?php echo e($user->email ?? ''); ?></span>
                            </li>
                        </ul>










                    </div>
                </div>
                <!--/ About User -->
                <!-- Profile Overview -->
                <div class="card mb-4">
                    <div class="card-body">
                        <p class="card-text text-uppercase">Overview</p>
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-check"></i><span class="fw-medium mx-2">Reply Compiled:</span>
                                <span><?php echo e($ReplyCompiled); ?></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="ti ti-layout-grid"></i><span class="fw-medium mx-2">Tickets Created:</span>
                                <span><?php echo e($TicketsCreated); ?></span>
                            </li>

                        </ul>
                    </div>
                </div>
                <!--/ Profile Overview -->
            </div>
            
        </div>
        <!--/ User Profile Content -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\user\profile.blade.php ENDPATH**/ ?>