<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr"
      data-theme="theme-default" data-assets-path="<?php echo e(asset('assets')); ?>/" data-template="vertical-menu-template">

<head>
    <meta charset="utf-8"/>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title><?php echo $__env->yieldContent('Page-title'); ?></title>
    <script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicon.ico')); ?>"/>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap"
        rel="stylesheet"/>

    <!-- Icons -->

    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/fontawesome.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/tabler-icons.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/flag-icons.css')); ?>"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/rtl/core.css')); ?>" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/rtl/theme-default.css')); ?>"
          class="template-customizer-theme-css"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/demo.css')); ?>"/>

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/node-waves/node-waves.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/typeahead-js/typeahead.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/quill/katex.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/quill/editor.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/select2/select2.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/toastr/toastr.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/animate-css/animate.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/tagify/tagify.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>"/>

    <link href="https://cdn.datatables.net/v/bs5/r-2.5.0/datatables.min.css" rel="stylesheet">
    <link
        href="https://cdn.datatables.net/v/bs4/jszip-3.10.1/dt-1.13.6/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/cr-1.7.0/date-1.5.1/sl-1.7.0/datatables.min.css"
        rel="stylesheet">
    <script src="<?php echo e(asset('assets/js/tinymce/tinymce.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>


    <!-- Page CSS -->
    <?php echo $__env->yieldContent('Page-css'); ?>
    <!-- Fix css-->
    <style>
        .template-customizer {
            bottom: 0 !important;
        }

        .tox-promotion {
            display: none;
        }

        .tox-statusbar__branding {
            display: none;
        }

        .light-style .select2-dropdown {
            z-index: 2000 !important;
        }

        #NotificationList img {
            max-width: 250px;
            height: auto;
        }

        span.select2-dropdown.select2-dropdown--below {
            z-index: 1500;
        }

        .email-card-prev .card-body p img {
            max-width: 100%;
            cursor: zoom-in;
        }
    </style>

    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>

    <!-- Helpers -->
    <script src="<?php echo e(asset('assets/vendor/libs/tagify/tagify.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/js/helpers.js')); ?>"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="<?php echo e(asset('assets/vendor/js/template-customizer.js')); ?>"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">

        <!-- Menu -->
        <?php echo $__env->make('layouts.sections.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php echo $__env->make('layouts.sections.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->

                <?php echo $__env->yieldContent('content'); ?>
                <!-- / Content -->
                <!-- Footer -->
                <?php echo $__env->make('layouts.sections.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>

</div>


<!-- / Layout wrapper -->

<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->

<script src="<?php echo e(asset('assets/vendor/libs/popper/popper.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/js/bootstrap.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/node-waves/node-waves.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/hammer/hammer.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/i18n/i18n.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/typeahead-js/typeahead.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/js/menu.js')); ?>"></script>

<!-- endbuild -->

<!-- Vendors JS -->
<script src="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/quill/katex.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/quill/quill.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/select2/select2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/block-ui/block-ui.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/toastr/toastr.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/extended-ui-sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/rateyo/rateyo.js')); ?>">
    <script src="<?php echo e(asset('assets/vendor/js/pdfmake/0.2.7/pdfmake.min.js')); ?>">
        <script src="<?php echo e(asset('assets/vendor/js/pdfmake/0.2.7/vfs_fonts.js')); ?>">

</script>
<script
    src="https://cdn.datatables.net/v/bs4/jszip-3.10.1/dt-1.13.6/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/cr-1.7.0/date-1.5.1/sl-1.7.0/datatables.min.js">
</script>
<script src="https://cdn.datatables.net/v/bs5/r-2.5.0/datatables.min.js"></script>

<!-- Main JS -->
<script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>

<!-- Page JS -->
<?php echo $__env->yieldContent('Page-script'); ?>
<script>
    let homepage = './';
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    function showErrors(jqXHR) {
        $('#validation').empty();
        if (jqXHR.status === 422) {
            var errors = jqXHR.responseJSON.errors;
            $.each(errors, function (key, value) {
                toastr.error(value[0], "Validation Form Error!", {
                    timeOut: 5000
                })
            });
        }
        if (jqXHR.status === 500 || jqXHR.status === 419) {
            var errors = jqXHR.responseJSON;
            toastr.error(errors.message, {
                timeOut: 5000
            })
        }
    }

    toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": true,
        "progressBar": true,
        "positionClass": "toast-top-right",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    }
    ReloadNotifications();
    // ReloadMessengers();


    $('#NotificationBell').click(function () {
        $(this).removeClass('ti-tada')
    })

    $('#NotiMakeReadAll').click(function () {
        console.log('132123321')
        $.ajax({
            type: "GET",
            url: `<?php echo e(route('notificationMakeReadAll')); ?>`,
            success: function (response) {
                ReloadNotifications();
            },
            errors: function (errors) {
                showErrors(errors);
            }
        });
    })
    //Delete Notification
    $('#NotificationList').on('click', 'a.dropdown-notifications-archive', function () {
        let liElement = $(this).closest('li');
        let NotiID = liElement.data('idnoti');
        $.ajax({
            type: "DELETE",
            url: `<?php echo e(route('notifications.destroy', '')); ?>/${NotiID}`,
            success: function (response) {
                ReloadNotifications();
            },
            errors: function (errors) {
                showErrors(errors);
            }
        });
    });
    //Read notification
    $('#NotificationList').on('click', 'li[data-read="false"]', function () {
        let NotiID = $(this).data('idnoti');
        $.ajax({
            type: "PUT",
            url: `<?php echo e(route('notifications.update', '')); ?>/${NotiID}`,
            success: function (response) {
                if (response.status === 'success') {
                    ReloadNotifications();
                }
            },
            errors: function (errors) {
                showErrors(errors);
            }
        });
    });

    let CountNoti = 0;

    //Function for notification
    function checkBel() {
        CountNoti++;
        if (CountNoti > 0) {
            var audio = $('#bellSound')[0];
            audio.play().then(() => {
                console.log("Playback started successfully");
            }).catch(error => {
                console.error("Error attempting to play audio:", error);
            });
        }
    }

    function ReloadNotifications() {
        let ListNoti = '';
        let NotiRead = '';
        let DataunRead = '';

        $.ajax({
            type: "GET",
            url: `<?php echo e(route('notifications.show', auth()->user()->id)); ?>`,
            success: function (response) {
                if (response.numUnread > 0) {
                    $('#notificationsCountBell').text(response.numUnread).show();
                    $('#NotiMakeReadAll').show();
                    $('#NotificationBell').addClass('ti-tada');
                    checkBel();
                } else {
                    $('#NotiMakeReadAll').hide();
                    $('#notificationsCountBell').hide();

                }
                let notifications = response.notifications;
                notifications.forEach(element => {
                    NotiRead = element.read_at === null ?
                        '<span class="badge badge-dot"></span></a>' : '';
                    DataunRead = element.read_at === null ? false : true;
                    ListNoti += `<li onclick="navigateToPage('${element.data.type}',${element.data.id})" class="list-group-item list-group-item-action dropdown-notifications-item" data-read="${DataunRead}" data-idNoti="${element.id}">
                <div class="d-flex">
                    <div class="flex-shrink-0 me-3">
                        <div class="avatar">
                            <img src="<?php echo e(asset('images/users/${element.data.user_id_created}.png')); ?>" alt="" class="h-auto rounded-circle">
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">${element.data.title}</h6>
                        <p class="mb-0">${element.data.text}</p>
                        <small class="text-muted">${moment(element.created_at).calendar()}</small>
                    </div>
                    <div class="flex-shrink-0 dropdown-notifications-actions">
                        <a href="#" class="dropdown-notifications-read">${NotiRead}</a>

                    </div>
                </div>
            </li>`
                });
            },
            complete: function () {
                $('#NotificationList').empty().append(ListNoti);


            }
        });
    }

    //Function for notification
    function ReloadMessengers() {
        let ListNoti = '';
        let NotiRead = '';
        let DataunRead = '';
        $.ajax({
            type: "GET",
            url: 'showMesNoti',
            success: function (response) {
                $('#MessengersBell_count').text(response.numUnread);
                let notifications = response.notifications;
                notifications.forEach(element => {

                    NotiRead = element.read_at === null ?
                        '<span class="badge badge-dot"></span></a>' : '';
                    DataunRead = element.read_at === null ? false : true;
                    ListNoti += `<li class="list-group-item list-group-item-action dropdown-notifications-item" data-read="${DataunRead}" data-idNoti="${element.id}">
                <div class="d-flex">
                    <div class="flex-shrink-0 me-3">
                        <div class="avatar">
                            <img src="<?php echo e(asset('images/users/${element.data.user_send}.png')); ?>" alt="" class="h-auto rounded-circle">
                        </div>
                    </div>
                    <div class="flex-grow-1" onclick="ReadMess('','${element.id}')">
                        <h6 class="mb-1">${element.data.title}</h6>

                        <small class="text-muted">${moment(element.created_at).calendar()}</small>
                    </div>
                    <div class="flex-shrink-0 dropdown-notifications-actions">
                        <a href="#" class="dropdown-notifications-read">${NotiRead}</a>
                        <a onclick="deleteNoti('${element.id}')" class="dropdown-notifications-archive"><span class="ti ti-x"></span></a>
                    </div>
                </div>
            </li>`
                });
            },
            complete: function () {
                $('#MessengersLists').empty().append(ListNoti);
            }
        });

    }

    function deleteNoti(id) {
        $.ajax({
            type: "DELETE",
            url: 'notifications/' + id,
            success: function (response) {
                ReloadMessengers();
            }
        });
    }

    function ReadMess(type, id) {
        $.ajax({
            type: "PUT",
            url: 'readMessengeNotification/' + id,
            success: function (response) {
                ReloadMessengers();
            }
        });
    }

    function navigateToPage(type, id) {
        switch (type) {
            case 'Ticket':
                window.location.href = '<?php echo e(route('index')); ?>' + '?s=' + id;
                break;


            default:
                break;
        }
    }


    var pusher = new Pusher('7691414fc2631bf8cb89', {
        cluster: 'ap1'
    });

    var channel = pusher.subscribe('TicketChannel');
    channel.bind("App\\Events\\CreateIssue", function (data) {
        HandleNotification(data)
    });


    function HandleNotification(data) {

        let dataNotification = data.data;
        let id_staff = parseInt(<?php echo e(Auth()->user()->id); ?>);

        let list_user_receive = dataNotification['user_receive']


        //check id_staff in list_user_receive or not
        // Chuyển mảng thành một mảng chứa các giá trị
        const values = Object.values(list_user_receive);

        console.log(id_staff)
        console.log(values)

        // Kiểm tra xem giá trị 1 có trong mảng không
        const hasOne = values.includes(id_staff);

        if (hasOne) {
            ReloadNotifications();
        } else {
            console.log('id_staff is not in list_user_receive');
            console.log('list_user_receive', list_user_receive)
            console.log('id_staff', id_staff)

        }

        if (typeof TicketShow === 'function') {
            let urlParams = new URLSearchParams(window.location.search);
            let sParam = urlParams.get('s');


            if (parseInt(sParam) === dataNotification.id) {
                let editor2 = tinymce.get('myTextarea');
                let replyContent = editor2.getContent();
                if (replyContent === '') {
                    TicketShow(dataNotification.id);
                }
            } else {
                if (current_page == 1) {
                    LoadAllTicket();
                }
            }

        } else {
            console.log('Hàm TicketShow chưa được định nghĩa');
        }

    }


</script>


</body>

</html>
<?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\layouts\master.blade.php ENDPATH**/ ?>