<?php $__env->startSection('page-title', 'Roles Control'); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card">
            <div class="card-header ui-sortable-handle" style="cursor: move;">
                <h3 class="card-title">
                    <i class="fas fa-user mr-1"></i>
                    Roles Control
                </h3>
                <div class="card-tools">
                    <button type="button" name="btnCreateForm" class="btn btn-primary"><i class="fa-solid fa-plus"></i>
                        New
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table class="datatables-basic table" id="table_index" style="width:100%"></table>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="ModalControl" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
             aria-labelledby="ModalControlLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <form id="FormID" data-type="">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h5 class="modal-title" id="ModalControlLabel">Modal Title</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div id="validation"></div>
                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" id="name" class="form-control">
                            </div>
                            <div class="form-group">
                                <label for="name">Permision</label>
                                <div class="select2-purple">
                                    <select name="permission[]" class="select2" multiple=true>
                                        <?php $__currentLoopData = $datas['permissions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value='<?php echo e($permission->id); ?>'><?php echo e($permission->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="guard_name">Guard name</label>
                                <input type="text" name="guard_name" id="guard_name" class="form-control">
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Create</button>
                                <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Close
                                </button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        //Route by BUIGA
        let updateRoute = "<?php echo e(route('admin.roles.update', '')); ?>";
        let storeRoute = "<?php echo e(route('admin.roles.store')); ?>";
        let showRoute = "<?php echo e(route('admin.roles.show', '')); ?>";
        let createRoute = "<?php echo e(route('admin.roles.create')); ?>";
        let destroyRoute = "<?php echo e(route('admin.roles.destroy', '')); ?>";

        function formCreate() {
            $('#FormID input[name="name"]').prop("disabled", false);
        }

        function formUpdate() {
            $('#FormID input[name="name"]').prop("disabled", true);
        }

        function beforeEdit(response) {
            permissions = response.permissions;
            var selectedPermissions = permissions.map(element => element.id);
            $('select[name="permission"]').val(selectedPermissions);
            $('select[name="permission"]').trigger('change');
        }

        $(document).ready(function () {
            $(".select2").select2();

            var table = $("#table_index").DataTable({
                processing: true,
                serverSide: false,
                ajax: {
                    url: createRoute,
                    dataSrc: "",
                },
                columns: [{
                    data: "id",
                    title: "id",
                },
                    {
                        data: "name",
                        title: "name",
                    },
                    {
                        "data": "permissions",
                        "render": function (data, type, row) {
                            var badgeHTML = "";
                            data.forEach(function (permission) {
                                badgeHTML += '<span class="badge bg-label-primary">' +
                                    permission + '</span>&nbsp;';
                            });
                            return badgeHTML;
                        }
                    },
                    {
                        data: "id",
                        title: "Action",
                        render: function (data) {
                            return (
                                '<button name="btnEdit"  data-id="' +
                                data +
                                '" class="btn btn-success"><i class="fa-solid fa-pen-to-square"></i> Edit</button> <button name="btnDel" data-id="' +
                                data +
                                '" class="btn btn-danger"><i class="fa-solid fa-trash"></i> Del</button>'
                            );
                        },
                    },
                ],
                order: [0, "desc"],
            });
            $("#FormID").on("submit", function (event) {
                event.preventDefault();
                var data = $(this).serializeArray();
                const permission = $('select[name="permission"]').val();

                var id = $(this).attr("data-id");
                switch (checkFormType()) {
                    case "edit":
                        $.ajax({
                            type: "PUT",
                            url: updateRoute + "/" + id,
                            data: data,
                            success: function (response) {
                                toastr.success(response.message, {
                                    timeOut: 5000,
                                });
                                table.ajax.reload();
                            },
                            error: function (jqXHR) {
                                showErrors(jqXHR);
                            },
                        });
                        break;
                    //submit create
                    default:
                        $.ajax({
                            url: storeRoute,
                            method: "POST",
                            data: data,
                            success: function (response) {
                                $("#validation")
                                    .empty()
                                    .append(
                                        '<div class="alert alert-success" role="alert">' +
                                        response.message +
                                        "</div>"
                                    );
                                table.ajax.reload();
                            },
                            error: function (jqXHR) {
                                showErrors(jqXHR);
                            },
                        });
                        break;
                }
            });

        });

    </script>
    <script src="<?php echo e(asset('js/pages/RolesPage.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laragon Projects\Ticketingsystem_V20_1_25\resources\views\admin\roles.blade.php ENDPATH**/ ?>